<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfNotAgent
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if (in_array($request->route()->getName(), ['agent.login', 'agent.login.submit'])) {
            return $next($request);
        }

        if (!Auth::guard('agent')->check()) {
            return redirect()->route('agent.login');
        }

        return $next($request);
    }
}
