<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class PreventCrossDomainAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $currentDomain = $request->getHost();
        $adminDomain = env('ADMIN_URL');
        $agentDomain = env('AGENT_URL');

        // If on admin domain but agent is logged in
        if ($currentDomain === $adminDomain && Auth::guard('agent')->check()) {
            Auth::guard('agent')->logout();
            $request->session()->invalidate();
        }

        // If on agent domain but admin is logged in
        if ($currentDomain === $agentDomain && Auth::guard('web')->check()) {
            Auth::guard('web')->logout();
            $request->session()->invalidate();
        }

        return $next($request);
    }
}
