<?php

namespace App\Http\Controllers;

use App\DataTables\AgentUsersDataTable;
use App\DataTables\UserDataTable;
use Illuminate\Http\Request;
use App\Models\User; // Added this import for the AgentUsers method

class UserController extends Controller
{
  public function index(Request $request)
  {
    $filters = [];
    if ($request->agent_id) {
      $filters = ['agent_id' => $request->agent_id];
    }
    $dataTable = new UserDataTable($filters);
    $breadcrumbs = [
      ['link' => "Users", 'name' => "Users"],
    ];
    return $dataTable->render('User.index', ['breadcrumbs' => $breadcrumbs], compact('filters'));
  }
  public function AgentUsers(Request $request)
  {
    $filters = [];
    if ($request->agent_id) {
      $filters = ['agent_id' => $request->agent_id];
    }
    $dataTable = new AgentUsersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Users", 'name' => "Users"],
    ];
    return $dataTable->render('User.index', ['breadcrumbs' => $breadcrumbs], compact('filters'));
  }
}
