<?php

namespace App\Http\Controllers;

use App\DataTables\AdvancedSearchDataTable;
use App\DataTables\Agents\ApprovalDataTable as AgentsApprovalDataTable;
use App\DataTables\Agents\BookingDataTable;
use App\DataTables\Agents\CollectTransfersDataTable;
use App\DataTables\Agents\InTransfersDataTable;
use App\DataTables\Agents\OutTransfersDataTable;
use App\DataTables\Agents\PayTransfersDataTable;
use App\DataTables\ApprovalDataTable;
use App\DataTables\BlockedTransfersDataTable;
use App\DataTables\BookingTransferTableDataTable;
use App\DataTables\CancelledDataTable;
use App\DataTables\DeletedBookingsDataTable;
use App\DataTables\ExchangeDataTable;
use App\DataTables\InTransfersDataTable as DataTablesInTransfersDataTable;
use App\DataTables\LiveWatchDataTable;
use App\DataTables\OutTransfersDataTable as DataTablesOutTransfersDataTable;
use App\DataTables\TransferDataTable;
use App\DataTables\TransferPackageDataTable;
use App\Events\RefreshDataTable;
use App\Livewire\Filter\AdvancedSearch;
use App\Models\Agent;
use App\Models\LedgerBooking;
use App\Models\LedgerTransfer;
use App\Services\Transfer\TransferService;
use Carbon\Carbon;
use Illuminate\Http\Request;

use function Rubix\ML\comb;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class TransferController extends Controller
{
  use AuthorizesRequests;
  public  function  index(TransferDataTable $dataTable, Request $request)
  {
    $show = $request->show ?? "all";

    $statusFilters = [
      'delivered' => ['show' => 'completed'],
      'undelivered' => ['show' => 'pending'],
      'all' => [], // No filter
    ];

    $filters = $statusFilters[$show] ?? [];
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('Transfers.index', ['breadcrumbs' => $breadcrumbs], compact('filters', 'show'));
  }
  public  function  Delivered(Request $request)
  {
    $show = "delivered";

    $statusFilters = [
      'delivered' => ['show' => 'completed'],
      'undelivered' => ['show' => 'pending'],
      'all' => [], // No filter
    ];

    $filters = $statusFilters[$show] ?? [];
    $dataTable = new TransferDataTable($filters);
    return $dataTable->render('Transfers.index', compact('filters'));
  }

  public  function  Undelivered(Request $request)
  {
    $show = "undelivered";

    $statusFilters = [
      'delivered' => ['show' => 'completed'],
      'undelivered' => ['show' => 'pending'],
      'all' => [], // No filter
    ];

    $filters = $statusFilters[$show] ?? [];
    $dataTable = new TransferDataTable($filters);
    return $dataTable->render('Transfers.index', compact('filters'));
  }

  public function Books(BookingTransferTableDataTable $dataTable, Request $request)
  {
    $type = $request->type ?? "booking";
    $title = __("Bookings");
    $filters = $request->get('filters', ['type' => $type]);
    return $dataTable->render("Booking.internal", compact('filters', 'title'));
  }
  public function DeletedBooks(DeletedBookingsDataTable $dataTable, Request $request)
  {
    $title = __("Deleted Bookings");
    $filters = $request->get('filters', ['type' => 'booking']);
    return $dataTable->render("Booking.internal", compact('filters', 'title'));
  }
  public function Approval(ApprovalDataTable $dataTable, Request $request)
  {
    $filters = $request->get('filters', ['type' => 'approval']);
    return $dataTable->render("Approval.index", compact('filters'));
  }
  public function ExternalApproval(Request $request)
  {
    $filters = $request->get('filters', ['type' => 'approval', 'approval_type' => 'external']);
    $dataTable = new ApprovalDataTable($filters);

    return $dataTable->render("Approval.index", compact('filters'));
  }

  public function Payment(BookingTransferTableDataTable $dataTable, Request $request)
  {
    $filters = $request->get('filters', ['type' => 'Payment']);
    return $dataTable->render("Booking.internal", compact('filters'));
  }
  public  function  Exchange(ExchangeDataTable $dataTable, Request $request)
  {

    $filters = $request->get('filters', ['type' => 'exchange']);
    return $dataTable->render("Exchange.index", compact('filters'));
  }
  public  function  Multi_currency(ExchangeDataTable $dataTable, Request $request)
  {

    $filters = $request->get('filters', ['type' => 'exchange']);
    return $dataTable->render("Exchange.multi_currency", compact('filters'));
  }
  public  function ExchangePrices()
  {
    return view("Exchange.prices");
  }
  public  function  AddLedger(Request $request)
  {

    $id = $request->id;
    $transfer = LedgerTransfer::latest()->first();

    $service = new TransferService();
    $result = $service->createTransferLedgerEntries($transfer);
  }
  public  function Packages(TransferPackageDataTable $dataTable)
  {
    return $dataTable->render("Transfers.packages");
  }
  public function  DeliverTransfer($transfer_id = null)
  {
    if ($transfer_id == null) {
      return view("Transfers.deliver");
    }
    $transfer = LedgerTransfer::with("client", "sender", "receiver")->find($transfer_id);
    return view("Transfers.deliver", compact('transfer'));
  }
  public function Search(Request $request)
  {


    $query = $request->input('search');

    $results = LedgerTransfer::query()
      ->when($query, fn($q) => $q->where('reference', 'like', "%$query%"))
      ->limit(10)
      ->get()
      ->map(fn($result) => [
        'id' => $result->id,
        'text' => $result->reference,
        "status" => "active"
      ]);

    return response()->json(['results' => $results]);
  }
  public function create()
  {

    return view("Transfers.add");
  }
  public  function edit($transfer_id)
  {

    return view("Transfers.add", compact('transfer_id'));
  }
  public function addBooking(Request $request)
  {
    $title = __("Add Booking");
    $type = $request->type ?? "booking";

    $filters = $request->get('filters', ['type' => $type, 'status' => 'completed', 'from_date' => Carbon::today()]);
    $dataTable = new BookingTransferTableDataTable($filters, 10);
    return $dataTable->render("Booking.add", compact('filters', 'title'));
    // return view("Booking.add", compact('filters', 'title'));
  }
  public function  EditBooking($id)
  {
    $title = __("Edit Booking");
    $type = $request->type ?? "booking";
    $filters =  ['type' => $type, 'status' => 'completed', 'from_date' => Carbon::today()];
    $booking = LedgerBooking::find($id);
    $this->authorize('update', $booking);
    $dataTable = new BookingTransferTableDataTable($filters, 10);
    return $dataTable->render("Booking.add", compact('id', 'filters', 'title'));
  }
  public  function  AdvancedSearch()
  {
    $title = __("Advanced Search");
    $dataTable = new AdvancedSearchDataTable();
    return $dataTable->render("Transfers.advanced_search", compact('title'));
  }
  public  function Livewatch(LiveWatchDataTable $dataTable)
  {
    $filters = [];
    return  $dataTable->render("Transfers.index", compact('filters'));
  }

  public  function AdministratorOutTransfers(Request $request)
  {
    $sender_id = $request->sender_id;

    $sender = Agent::findorFail($sender_id);

    $title = __("Out Transfers");


    $filters =  ['sender_id' => $sender_id];
    $dataTable = new DataTablesOutTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('Transfers.index', ['breadcrumbs' => $breadcrumbs], compact('filters', 'title'));
  }
  public  function AdministratorInTransfers(Request $request)
  {
    $receiver_id = $request->receiver_id;


    $title = __("In Transfers");
    $filters =  ['receiver_id' => $receiver_id];
    $dataTable = new DataTablesInTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('Transfers.index', ['breadcrumbs' => $breadcrumbs], compact('filters', 'title'));
  }
  public function BlockedTransfers(Request $request)
  {
    $filters = $request->get('filters', ['status' => 'blocked']);
    $dataTable = new BlockedTransfersDataTable($filters);
    return $dataTable->render('Transfers.index', compact('filters'));
  }
  public function CanceledTransfers(Request $request)
  {
    $filters = $request->get('filters', ['status' => 'cancelled']);
    $dataTable = new CancelledDataTable($filters);
    return $dataTable->render('Transfers.index', compact('filters'));
  }


  /////////////////////////////////////Agent///////////////////////////////
  public function addAgentBooking(Request $request)
  {
    $title = __("Add Booking");
    $type = $request->type ?? "booking";

    $filters = $request->get('filters', ['type' => $type]);
    return view("AgentPanel.Booking.add", compact('filters', 'title'));
  }
  public function AgentBooks(Request $request)
  {
    $title = __("List Booking");
    $dataTable = new BookingDataTable();
    return $dataTable->render("AgentPanel.Booking.internal", compact('title'));
  }
  public  function OutTransfers()
  {
    $sender_id = auth()->guard('agent')->user()->agent->rootAgent()->id;
    $title = __("Out Transfers");


    $filters =  ['sender_id' => $sender_id];
    $dataTable = new OutTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('AgentPanel.Transfer.out_transfers', ['breadcrumbs' => $breadcrumbs], compact('filters', 'title'));
  }
  public  function InTransfers()
  {
    $sender_id = auth()->guard('agent')->user()->agent->rootAgent()->id;


    $title = __("In Transfers");
    $filters =  [];
    $dataTable = new InTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('AgentPanel.Transfer.in_transfers', ['breadcrumbs' => $breadcrumbs], compact('filters', 'title'));
  }

  public  function PayTransfer($type = null)
  {
    $agent = auth()->guard('agent')->user()->agent;
    $sender_id = $agent->rootAgent()->id;
    $title = __("Pay Transfers");
    if ($type == "collect") {
      $title = __("Collect Transfers");
    }

    $filters =  [];
    $dataTable = new PayTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => __("Pay Transfers")],
    ];
    return $dataTable->render('AgentPanel.Transfer.pay_transfers', ['breadcrumbs' => $breadcrumbs], compact('filters', 'agent', "title"));
  }
  public  function CollectTransfer($type = null)
  {
    $agent = auth()->guard('agent')->user()->agent;
    $sender_id = $agent->rootAgent()->id;

    $title = __("Collect Transfers");


    $filters =  [];
    $dataTable = new CollectTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => __("Collect Transfers")],
    ];
    return $dataTable->render('AgentPanel.Transfer.pay_transfers', ['breadcrumbs' => $breadcrumbs], compact('filters', 'agent', "title"));
  }

  public  function DeliveredTransfers()
  {
    $sender_id = auth()->guard('agent')->user()->agent->rootAgent()->id;
    $title = __("Delivered Transfers");


    $filters =  ['sender_id' => $sender_id, 'status' => 'completed'];
    $dataTable = new OutTransfersDataTable($filters);
    $breadcrumbs = [
      ['link' => "Transfers", 'name' => "Transfers"],
    ];
    return $dataTable->render('AgentPanel.Transfer.out_transfers', ['breadcrumbs' => $breadcrumbs], compact('filters', 'title'));
  }
  public function AgentApproval(Request $request)
  {
    $type = "out";
    $sender_id = auth()->guard('agent')->user()->agent->rootAgent()->id;

    $filters = $request->get('filters', ['type' => 'approval', 'sender_id' => $sender_id]);
    $dataTable = new AgentsApprovalDataTable($filters, $type);
    return $dataTable->render("AgentPanel.Approval.in_approval", compact('filters'));
  }
  public function InAgentApproval(Request $request)
  {
    $title = __("InApproval");
    $type = "in";
    $receiver_id = auth()->guard('agent')->user()->agent->rootAgent()->id;
    $filters = $request->get('filters', ['type' => 'approval', 'receiver_id' => $receiver_id,]);
    $dataTable = new AgentsApprovalDataTable($filters, $type);

    return $dataTable->render("AgentPanel.Approvals.in_approval", compact('filters', 'title'));
  }
  public function OutAgentApproval(Request $request)
  {
    $title = __("OutApproval");
    $type = "out";
    $sender_id = auth()->guard('agent')->user()->agent->rootAgent()->id;
    $filters = $request->get('filters', ['type' => 'approval', 'sender_id' => $sender_id]);
    $dataTable = new AgentsApprovalDataTable($filters, $type);
    return $dataTable->render("AgentPanel.Approvals.in_approval", compact('filters', 'title'));
  }
  public function AgentDeliveredApprovals(Request $request)
  {
    $title = __("Delivered Approvals");
    $type = "out";
    $receiver = auth()->guard('agent')->user()->agent->rootAgent()->id;
    $filters = $request->get('filters', ['type' => 'approval', 'receiver_id' => $receiver, 'status' => 'completed']);
    $dataTable = new AgentsApprovalDataTable($filters, $type);
    return $dataTable->render("AgentPanel.Approvals.in_approval", compact('filters', 'title'));
  }
  public function AgentDeliverTransfer(Request $request)
  {
    $id = $request->id;
    $transfer = LedgerTransfer::find($id);
    $transfer = $transfer->makeHidden('secret');
    return  view("AgentPanel.Transfer.deliver", compact('transfer'));
  }
  public  function AgentLivewatch(LiveWatchDataTable $dataTable)
  {
    $filters = [];
    $title = __("Livewatch");
    return  $dataTable->render("AgentPanel.Transfer.livewatch", compact('filters', 'title'));
  }
  public  function AgentAdvancedSearch(AdvancedSearchDataTable $dataTable)
  {
    $filters = [];
    $title = __("Advanced Search");
    return  $dataTable->render("AgentPanel.Transfer.advanced_search", compact('filters', 'title'));
  }
  public  function AgentExchange(ExchangeDataTable $dataTable)
  {
    $filters = [];
    $title = __("Exchange");
    return  $dataTable->render("AgentPanel.Transfer.exchange", compact('filters', 'title'));
  }
}
