<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\LedgerTransfer;

use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class OutgoingTransfersExport implements FromCollection, WithHeadings, WithMapping
{
    public function __construct(protected $from, protected $to) {}

    public function collection()
    {
        return LedgerTransfer::query()->whereBetween('created_at', [$this->from, $this->to])
            ->get([
                'id',
                'reference',


                'sender_id',
                'receiver_id',
                'amount',
                'currency',
                'delivery_amount',
                'delivery_currency',
                'client_id',
                'recipient_client_id',
                'status',
                'created_at'
            ]);
    }
    public function map($transfer): array
    {
        return [
            $transfer->reference,
            $transfer->sender?->name ?? 'N/A',
            $transfer->client?->name ?? 'N/A',
            $transfer->client?->getFullAddress(),
            $transfer->client?->getPrimaryAddress()->country ?? 'N/A',
            $transfer->client?->IdentityType->name ?? 'N/A',
            $transfer->client?->identity_number ?? 'N/A',
            $transfer->recipient_client?->name ?? 'N/A',
            $transfer->recipient_client?->mother_name ?? 'N/A',
            $transfer->recipient_client?->getFullAddress(),
            $transfer->receiver?->name ?? 'N/A',
            $transfer->amount,
            $transfer->currency,

            $transfer->created_at->toDateTimeString(),
        ];
    }
    public function headings(): array
    {
        return ['رقم  الحوالة', 'المصدر', 'اسم المرسل', 'العنوان', 'الدولة', 'نوع الهوية', 'رقم الهوية', 'اسم المستلم', 'اسم الام', 'العنوان', 'اسم المستلم', 'المبلغ', 'العملة', 'تاريخ  التصدير'];
    }
}
