<?php

namespace App\Exceptions;

use Exception;

class AgentHasBalanceException extends Exception
{
    protected $balance;

    public function __construct($message = '', $balance = null)
    {
        $this->balance = $balance;
        parent::__construct(
            $message ?: 'Cannot delete agent with existing balance: ' . $balance,
            422
        );
    }

    public function getBalance()
    {
        return $this->balance;
    }
}
