<?php

namespace App\Console\Commands;

use App\Models\NotificationTemplate;
use Illuminate\Console\Command;
use App\Models\User;
use App\Services\Sms\NotificationService;
use Rawilk\Settings\Facades\Settings;

class sendCustomerReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminders:send-contract-sms';

    protected $description = 'Send SMS reminders for each unpaid contract invoice per customer';

    /**
     * The console command description.
     *
     * @var string
     */

    protected NotificationService $notifier;

    public function __construct(NotificationService $notifier)
    {
        parent::__construct();
        $this->notifier = $notifier;
    }
    /**
     * Execute the console command.
     */
    public function handle()
    {
        // You can filter by active customers, etc.
        $customers = User::where('type', 'Tenant')->get();

        foreach ($customers as $customer) {
            $this->sendCustomerReminders($customer);
        }

        $this->info("Contract reminders sent.");
    }
    protected function sendCustomerReminders(User $customer)
    {
        $templates = Settings::get('notifications.templates', []);
        $templateId = $templates['late_payment']['sms'] ?? null;
        $remindersms = NotificationTemplate::find($templateId);
        $reminder_day = 3;
        foreach ($customer->contracts as $contract) {


            $unpaidInvoice = $contract->invoices->filter(fn($invoice) => $invoice->payments->sum('amount') < $invoice->amount)->where('due_date', '>=', now()->addDays($reminder_day))->sortBy('due_date')->first();

            if ($unpaidInvoice) {

                $this->notifier->sendCustomerNotification($customer, $remindersms->title, [
                    'balance' => $unpaidInvoice->amount - $unpaidInvoice->payments->sum('amount'),
                    'last_pay_day' => $unpaidInvoice->due_date,
                    'last_pay_date' => $unpaidInvoice->due_date,
                    'payment_day' => $contract->payment_day,
                    'contract_start_date' => $contract->contract_start,
                    'contract_end_date' => $contract->contract_end,
                    'property_name' => $contract->property->name,
                    'status' => $contract->status,
                    'pr_block' => optional($contract->property)->block,
                    'pr_building_number' => optional($contract->property)->bbno,
                    'bbno' => optional($contract->property)->bbno,
                    'pf_name' => optional($contract->portfolio)->name,

                ]);
            }
        }
    }
}
