<?php

namespace App\Console\Commands;

use App\Models\Policy;
use Illuminate\Console\Command;

class UpdatePolicyStatuses extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:update-policy-statuses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $updated = Policy::query()
            ->whereIn('status', ['pending', 'active'])
            ->each(function ($policy) {
                $newStatus = $policy->calculateStatus();
                if ($newStatus !== $policy->status) {
                    $policy->update(['status' => $newStatus]);
                }
            });

        $this->info("Policy statuses updated successfully.");
    }
}
