<?php

namespace App\Console\Commands;

use App\Services\ExchangeRates\ExchangeRateManager;
use App\Services\ExchangeRates\Providers\HaramAltinProvider;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;

class FetchExchangeRates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:fetch-exchange-rates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {








        $defaultProvider = config('Orange.exchange.default');
        $manager = new ExchangeRateManager($defaultProvider);

        $rates = Cache::remember('exchange_rates', 60, function () use ($manager) {
            return $manager->getProvider()->getAllRates();
        });
    }
}
