<?php

namespace App\Console\Commands;

use App\Models\Invoice;
use Illuminate\Console\Command;

class ApplyInvoiceInterest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'contract:apply-invoice-interest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = ' Apply interest to overdue invoices based on their due date and interest rate';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Invoice::where('status', 'overdue')->each(function ($invoice) {
            $interest = $invoice->calculateInterest();

            if ($interest > 0) {
                // Check if interest item already exists
                $interestItem = $invoice->items()->where('type', 'interest')->first();

                if ($interestItem) {
                    // Update existing interest amount
                    $interestItem->update(['amount' => $interest]);
                } else {
                    // Create new interest item
                    $invoice->items()->create([
                        'title' => 'Late Payment Interest',
                        'amount' => $interest,
                        'type' => 'interest',
                        'description' => 'Interest applied for overdue payment',
                        'quantity' => 1,
                        'unit_price' => $interest,
                        'tax_rate' => 0, // Assuming no tax on interest
                        'tax_type' => 'none',
                        'total_amount' => $interest

                    ]);
                }
            }
        });
    }
}
