<?php

namespace App\AuditResolvers;

use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\Resolver;
use   App\Services\Resolver\Ipresolver;
use CountryCodes;
use Illuminate\Support\Facades\Request;

class CountryResolver implements Resolver
{
    public static function resolve(Auditable $auditable)
    {
        $ipresolver = new Ipresolver();
        $ip = $auditable->preloadedResolverData['ip_address'] ?? Request::ip();
        $data = $ipresolver->Resolve($ip);

        return    $icon = CountryCodes::getEmojiByAlpha2($data->countryCode ?? "SY");
    }
}
