/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksFileVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(JwksFileVerificationKeyResolver.class);
    private final Path jwksFile;
    private VerificationKeyResolver delegate;

    public JwksFileVerificationKeyResolver(Path jwksFile) {
        this.jwksFile = jwksFile;
    }

    @Override
    public void init() throws IOException {
        JsonWebKeySet jwks;
        log.debug("Starting creation of new VerificationKeyResolver from {}", (Object)this.jwksFile);
        String json = Utils.readFileAsString(this.jwksFile.toFile().getPath());
        try {
            jwks = new JsonWebKeySet(json);
        }
        catch (JoseException e) {
            throw new IOException(e);
        }
        this.delegate = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (this.delegate == null) {
            throw new UnresolvableKeyException("VerificationKeyResolver delegate is null; please call init() first");
        }
        return this.delegate.resolveKey(jws, nestingContext);
    }
}

