/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DescribeQuorumResponse
extends AbstractResponse {
    private final DescribeQuorumResponseData data;

    public DescribeQuorumResponse(DescribeQuorumResponseData data) {
        super(ApiKeys.DESCRIBE_QUORUM);
        this.data = data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        for (DescribeQuorumResponseData.TopicData topicResponse : this.data.topics()) {
            for (DescribeQuorumResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                this.updateErrorCounts(errors, Errors.forCode(partitionResponse.errorCode()));
            }
        }
        return errors;
    }

    @Override
    public DescribeQuorumResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static DescribeQuorumResponseData singletonErrorResponse(TopicPartition topicPartition, Errors error) {
        return new DescribeQuorumResponseData().setTopics(Collections.singletonList(new DescribeQuorumResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new DescribeQuorumResponseData.PartitionData().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code())))));
    }

    public static DescribeQuorumResponseData singletonResponse(TopicPartition topicPartition, DescribeQuorumResponseData.PartitionData partitionData) {
        return new DescribeQuorumResponseData().setTopics(Collections.singletonList(new DescribeQuorumResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(partitionData.setPartitionIndex(topicPartition.partition())))));
    }

    public static DescribeQuorumResponse parse(ByteBuffer buffer, short version) {
        return new DescribeQuorumResponse(new DescribeQuorumResponseData(new ByteBufferAccessor(buffer), version));
    }
}

