/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConsumerGroupState {
    UNKNOWN("Unknown"),
    PREPARING_REBALANCE("PreparingRebalance"),
    COMPLETING_REBALANCE("CompletingRebalance"),
    STABLE("Stable"),
    DEAD("Dead"),
    EMPTY("Empty");

    private static final Map<String, ConsumerGroupState> NAME_TO_ENUM;
    private final String name;

    private ConsumerGroupState(String name) {
        this.name = name;
    }

    public static ConsumerGroupState parse(String name) {
        ConsumerGroupState state = NAME_TO_ENUM.get(name);
        return state == null ? UNKNOWN : state;
    }

    public String toString() {
        return this.name;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(ConsumerGroupState.values()).collect(Collectors.toMap(state -> state.name, Function.identity()));
    }
}

