/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer;

import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

public final class RecordMetadata {
    public static final int UNKNOWN_PARTITION = -1;
    private final long offset;
    private final long timestamp;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private final TopicPartition topicPartition;

    public RecordMetadata(TopicPartition topicPartition, long baseOffset, int batchIndex, long timestamp, int serializedKeySize, int serializedValueSize) {
        this.offset = baseOffset == -1L ? baseOffset : baseOffset + (long)batchIndex;
        this.timestamp = timestamp;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        this.topicPartition = topicPartition;
    }

    @Deprecated
    public RecordMetadata(TopicPartition topicPartition, long baseOffset, long batchIndex, long timestamp, Long checksum, int serializedKeySize, int serializedValueSize) {
        this(topicPartition, baseOffset, RecordMetadata.batchIndexToInt(batchIndex), timestamp, serializedKeySize, serializedValueSize);
    }

    private static int batchIndexToInt(long batchIndex) {
        if (batchIndex > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("batchIndex is larger than Integer.MAX_VALUE: " + batchIndex);
        }
        return (int)batchIndex;
    }

    public boolean hasOffset() {
        return this.offset != -1L;
    }

    public long offset() {
        return this.offset;
    }

    public boolean hasTimestamp() {
        return this.timestamp != -1L;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public int serializedKeySize() {
        return this.serializedKeySize;
    }

    public int serializedValueSize() {
        return this.serializedValueSize;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String toString() {
        return this.topicPartition.toString() + "@" + this.offset;
    }
}

